/************************************************************************************************
*   深圳市摩西尔电子有限公司 @版本所有@
*
*   此文件用于PC端Web显示壳NWJS操作接口
*
* 修改:
*   1. 类型 : 创建
*      作者 : 张启丰
*      时间 : 2019.05.06
*      内容 : 所有代码
*************************************************************************************************/

/* exported  mc_nwjs_check_support */
/* exported  mc_nwjs_win_minimize */
/* exported  mc_nwjs_win_maximize */
/* exported  mc_nwjs_win_restore */
/* exported  mc_nwjs_win_fullscreen_enter */
/* exported  mc_nwjs_win_fullscreen_leave */
/* exported  mc_nwjs_win_get_pos_x */
/* exported  mc_nwjs_win_get_pos_y */
/* exported  mc_nwjs_win_set_position */
/* exported  mc_nwjs_win_get_width */
/* exported  mc_nwjs_win_get_height */
/* exported  mc_nwjs_win_set_resizable */
/* exported  mc_nwjs_win_set_max_size */
/* exported  mc_nwjs_win_set_min_size */
/* exported  mc_nwjs_win_set_size */
/* exported  mc_nwjs_win_get_title */
/* exported  mc_nwjs_win_set_title */
/* exported  mc_nwjs_win_set_show */
/* exported  mc_nwjs_win_set_top_most */
/* exported  mc_nwjs_win_close */
/* exported  mc_nwjs_win_maximize_callback */
/* exported mc_nwjs_win_restore_callback */
/* exported mc_nwjs_create_process */
/* exported mc_nwjs_save_file */

/* global nw */
/* global require */

/************************************************************************************************
* 类型:
*    函数
* 功能:
*    判断平台是否支持此文件函数
* 参数:
*    NA
* 返回：
*    @returns { Promise<Boolean> }
*    错误码:
*      true = 平台支持
*      false = 平台不支持
* 例子：
*    NA
* 备注：
*    NA
* 修改:
*   1. 类型 : 创建
*      作者 : 张启丰
*      时间 : 2019.05.06
*      内容 : 所有代码
************************************************************************************************/
function mc_nwjs_check_support() {
    try {
        if (nw) {
            return true;
        }
        return false;
    } catch (ex) {
        return false;
    }
}

/************************************************************************************************
* 类型:
*    函数
* 功能:
*    将窗口最小化
* 参数:
*    NA
* 返回：
*    @returns { Promise<Number> }
*    错误码:
*      0 = 无错误
*      1 = 平台不支持
* 例子：
*    NA
* 备注：
*    NA
* 修改:
*   1. 类型 : 创建
*      作者 : 张启丰
*      时间 : 2019.05.06
*      内容 : 所有代码
************************************************************************************************/
function mc_nwjs_win_minimize() {
    try {
        var gui = require("nw.gui");

        if (!gui) {
            return 1;
        }

        var win = gui.Window.get();

        if (!win) {
            return 1;
        }

        win.minimize();
    } catch (err) {
        return 1;
    }

    return 0;
}

/************************************************************************************************
* 类型:
*    函数
* 功能:
*    将窗口最大化
* 参数:
*    NA
* 返回：
*    @returns { Promise<Number> }
*    错误码:
*      0 = 无错误
*      1 = 平台不支持
* 例子：
*    NA
* 备注：
*    NA
* 修改:
*   1. 类型 : 创建
*      作者 : 张启丰
*      时间 : 2019.05.06
*      内容 : 所有代码
************************************************************************************************/
function mc_nwjs_win_maximize() {
    try {
        var gui = require("nw.gui");

        if (!gui) {
            return 1;
        }

        var win = gui.Window.get();

        if (!win) {
            return 1;
        }

        win.maximize();
    } catch (err) {
        return 1;
    }

    return 0;
}

/************************************************************************************************
* 类型:
*    函数
* 功能:
*    将窗口尺寸恢复（常用于最大化后的恢复）
* 参数:
*    NA
* 返回：
*    @returns { Promise<Number> }
*    错误码:
*      0 = 无错误
*      1 = 平台不支持
* 例子：
*    NA
* 备注：
*    NA
* 修改:
*   1. 类型 : 创建
*      作者 : 张启丰
*      时间 : 2019.05.06
*      内容 : 所有代码
************************************************************************************************/
function mc_nwjs_win_restore() {
    try {
        var gui = require("nw.gui");

        if (!gui) {
            return 1;
        }

        var win = gui.Window.get();

        if (!win) {
            return 1;
        }

        win.restore();
    } catch (err) {
        return 1;
    }
    return 0;
}

/************************************************************************************************
* 类型:
*    函数
* 功能:
*    将窗口设置为全屏
* 参数:
*    NA
* 返回：
*    @returns { Promise<Number> }
*    错误码:
*      0 = 无错误
*      1 = 平台不支持
* 例子：
*    NA
* 备注：
*    NA
* 修改:
*   1. 类型 : 创建
*      作者 : 张启丰
*      时间 : 2019.05.06
*      内容 : 所有代码
************************************************************************************************/
function mc_nwjs_win_fullscreen_enter() {
    try {
        var gui = require("nw.gui");

        if (!gui) {
            return 1;
        }

        var win = gui.Window.get();

        if (!win) {
            return 1;
        }

        win.enterFullscreen();
    } catch (err) {
        return 1;
    }
    return 0;
}

/************************************************************************************************
* 类型:
*    函数
* 功能:
*    将窗口退出全屏
* 参数:
*    NA
* 返回：
*    @returns { Promise<Number> }
*    错误码:
*      0 = 无错误
*      1 = 平台不支持
* 例子：
*    NA
* 备注：
*    NA
* 修改:
*   1. 类型 : 创建
*      作者 : 张启丰
*      时间 : 2019.05.06
*      内容 : 所有代码
************************************************************************************************/
function mc_nwjs_win_fullscreen_leave() {
    try {
        var gui = require("nw.gui");

        if (!gui) {
            return 1;
        }

        var win = gui.Window.get();

        if (!win) {
            return 1;
        }

        win.leaveFullscreen();
    } catch (err) {
        return 1;
    }
    return 0;
}

/************************************************************************************************
* 类型:
*    函数
* 功能:
*    获取窗口水平位置
* 参数:
*    NA
* 返回：
*    @returns { Promise<Number> }
*    错误码:
*      -1 = 平台不支持
*      其它 = 窗口水平位置
* 例子：
*    NA
* 备注：
*    NA
* 修改:
*   1. 类型 : 创建
*      作者 : 张启丰
*      时间 : 2019.05.06
*      内容 : 所有代码
************************************************************************************************/
function mc_nwjs_win_get_pos_x() {
    try {
        var gui = require("nw.gui");

        if (!gui) {
            return -1;
        }

        var win = gui.Window.get();

        if (!win) {
            return -1;
        }

        return win.x;
    } catch (err) {
        return -1;
    }
}

/************************************************************************************************
* 类型:
*    函数
* 功能:
*    获取窗口垂直位置
* 参数:
*    NA
* 返回：
*    @returns { Promise<Number> }
*    错误码:
*      -1 = 平台不支持
*      其它 = 窗口垂直位置
* 例子：
*    NA
* 备注：
*    NA
* 修改:
*   1. 类型 : 创建
*      作者 : 张启丰
*      时间 : 2019.05.06
*      内容 : 所有代码
************************************************************************************************/
function mc_nwjs_win_get_pos_y() {
    try {
        var gui = require("nw.gui");

        if (!gui) {
            return -1;
        }

        var win = gui.Window.get();

        if (!win) {
            return -1;
        }

        return win.y;
    } catch (err) {
        return -1;
    }
}

/************************************************************************************************
* 类型:
*    函数
* 功能:
*    获取窗口位置
* 参数:
*    @param { Promise<Number> } x 窗口水平位置
*    @param { Promise<Number> } y 窗口垂直位置
* 返回：
*    @returns { Promise<Number> }
*    错误码:
*      0 = 无错误
*      1 = 平台不支持
*      2 = 参数类型错误
* 例子：
*    NA
* 备注：
*    NA
* 修改:
*   1. 类型 : 创建
*      作者 : 张启丰
*      时间 : 2019.05.06
*      内容 : 所有代码
************************************************************************************************/
function mc_nwjs_win_set_position(x, y) {
    try {
        var gui = require("nw.gui");

        if (!gui) {
            return 1;
        }

        var win = gui.Window.get();

        if (!win) {
            return 1;
        }

        if ("number" !== typeof x || 0 !== x % 1 ||
            "number" !== typeof y || 0 !== y % 1) {
            return 2;
        }

        win.moveTo(x, y);
        return 0;
    } catch (err) {
        return 1;
    }
}

/************************************************************************************************
* 类型:
*    函数
* 功能:
*    获取窗口宽
* 参数:
*    NA
* 返回：
*    @returns { Promise<Number> }
*    错误码:
*      -1 = 平台不支持
*      其它 = 窗口宽
* 例子：
*    NA
* 备注：
*    NA
* 修改:
*   1. 类型 : 创建
*      作者 : 张启丰
*      时间 : 2019.05.06
*      内容 : 所有代码
************************************************************************************************/
function mc_nwjs_win_get_width() {
    try {
        var gui = require("nw.gui");

        if (!gui) {
            return -1;
        }

        var win = gui.Window.get();

        if (!win) {
            return -1;
        }
        return win.width;
    } catch (err) {
        return 0;
    }
}

/************************************************************************************************
* 类型:
*    函数
* 功能:
*    获取窗口高
* 参数:
*    NA
* 返回：
*    @returns { Promise<Number> }
*    错误码:
*      -1 = 平台不支持
*      其它 = 窗口高
* 例子：
*    NA
* 备注：
*    NA
* 修改:
*   1. 类型 : 创建
*      作者 : 张启丰
*      时间 : 2019.05.06
*      内容 : 所有代码
************************************************************************************************/
function mc_nwjs_win_get_height() {
    try {
        var gui = require("nw.gui");

        if (!gui) {
            return -1;
        }

        var win = gui.Window.get();

        if (!win) {
            return -1;
        }

        return win.height;
    } catch (err) {
        return 0;
    }
}

/************************************************************************************************
* 类型:
*    函数
* 功能:
*    设置窗口尺寸修改使能
* 参数:
*    @param { Promise<Boolean> } enable
* 返回：
*    @returns { Promise<Number> }
*    错误码:
*      0 = 无错误
*      1 = 平台不支持
*      2 = 参数类型错误
* 例子：
*    NA
* 备注：
*    NA
* 修改:
*   1. 类型 : 创建
*      作者 : 张启丰
*      时间 : 2019.05.06
*      内容 : 所有代码
************************************************************************************************/
function mc_nwjs_win_set_resizable(enable) {
    try {
        var gui = require("nw.gui");

        if (!gui) {
            return 1;
        }

        var win = gui.Window.get();

        if (!win) {
            return 1;
        }

        if ("boolean" != typeof enable) {
            return 2;
        }

        win.setResizable(enable);
        return 0;
    } catch (err) {
        return 1;
    }
}

/************************************************************************************************
* 类型:
*    函数
* 功能:
*    设置窗口最大尺寸
* 参数:
*    @param { Promise<Number> } width 窗口宽
*    @param { Promise<Number> } height 窗口高
* 返回：
*    @returns { Promise<Number> }
*    错误码:
*      0 = 无错误
*      1 = 平台不支持
*      2 = 参数类型错误
* 例子：
*    NA
* 备注：
*    NA
* 修改:
*   1. 类型 : 创建
*      作者 : 张启丰
*      时间 : 2019.05.06
*      内容 : 所有代码
************************************************************************************************/
function mc_nwjs_win_set_max_size(width, height) {
    try {
        var gui = require("nw.gui");

        if (!gui) {
            return 1;
        }

        var win = gui.Window.get();

        if (!win) {
            return 1;
        }

        if ("number" !== typeof width || 0 !== width % 1 ||
            "number" !== typeof height || 0 !== height % 1) {
            return 2;
        }

        win.setMaximumSize(width, height);
        return 0;
    } catch (err) {
        return 1;
    }
}

/************************************************************************************************
* 类型:
*    函数
* 功能:
*    设置窗口最小尺寸
* 参数:
*    @param { Promise<Number> } width 窗口宽
*    @param { Promise<Number> } height 窗口高
* 返回：
*    @returns { Promise<Number> }
*    错误码:
*      0 = 无错误
*      1 = 平台不支持
*      2 = 参数类型错误
* 例子：
*    NA
* 备注：
*    NA
* 修改:
*   1. 类型 : 创建
*      作者 : 张启丰
*      时间 : 2019.05.06
*      内容 : 所有代码
************************************************************************************************/
function mc_nwjs_win_set_min_size(width, height) {
    try {
        var gui = require("nw.gui");

        if (!gui) {
            return 1;
        }

        var win = gui.Window.get();

        if (!win) {
            return 1;
        }

        if ("number" !== typeof width || 0 !== width % 1 ||
            "number" !== typeof height || 0 !== height % 1) {
            return 2;
        }

        win.setMinimumSize(width, height);
        return 0;
    } catch (err) {
        return 1;
    }
}

/************************************************************************************************
* 类型:
*    函数
* 功能:
*    设置窗口尺寸
* 参数:
*    @param { Promise<Number> } width 窗口宽
*    @param { Promise<Number> } height 窗口高
* 返回：
*    @returns { Promise<Number> }
*    错误码:
*      0 = 无错误
*      1 = 平台不支持
*      2 = 参数类型错误
* 例子：
*    NA
* 备注：
*    NA
* 修改:
*   1. 类型 : 创建
*      作者 : 张启丰
*      时间 : 2019.05.06
*      内容 : 所有代码
************************************************************************************************/
function mc_nwjs_win_set_size(width, height) {
    try {
        var gui = require("nw.gui");

        if (!gui) {
            return 1;
        }

        var win = gui.Window.get();

        if (!win) {
            return 1;
        }

        if ("number" !== typeof width || 0 !== width % 1 ||
            "number" !== typeof height || 0 !== height % 1) {
            return 2;
        }

        win.resizeTo(width, height);
        return 0;
    } catch (err) {
        return 1;
    }
}

/************************************************************************************************
* 类型:
*    函数
* 功能:
*    获取窗口标题
* 参数:
*    NA
* 返回：
*    @returns { Promise<String> } 窗口标题 长度为0时，表示平台不支持或者没有标题
* 例子：
*    NA
* 备注：
*    NA
* 修改:
*   1. 类型 : 创建
*      作者 : 张启丰
*      时间 : 2019.05.06
*      内容 : 所有代码
************************************************************************************************/
function mc_nwjs_win_get_title() {
    try {
        var gui = require("nw.gui");

        if (!gui) {
            return 1;
        }

        var win = gui.Window.get();

        if (!win) {
            return 1;
        }

        return win.title;
    } catch (err) {
        return "";
    }
}

/************************************************************************************************
* 类型:
*    函数
* 功能:
*    设置窗口标题
* 参数:
*    @param { Promise<String> } title 窗口标题
* 返回：
*    @returns { Promise<Number> }
*    错误码:
*      0 = 无错误
*      1 = 平台不支持
*      2 = 参数类型错误
* 例子：
*    NA
* 备注：
*    NA
* 修改:
*   1. 类型 : 创建
*      作者 : 张启丰
*      时间 : 2019.05.06
*      内容 : 所有代码
************************************************************************************************/
function mc_nwjs_win_set_title(title) {
    try {
        var gui = require("nw.gui");

        if (!gui) {
            return 1;
        }

        var win = gui.Window.get();

        if (!win) {
            return 1;
        }

        if ("string" !== typeof title) {
            return 2;
        }

        win.title = title;
    } catch (err) {
        return 1;
    }
    return 0;
}

/************************************************************************************************
* 类型:
*    函数
* 功能:
*    设置窗口显示状态
* 参数:
*    @param { Promise<Boolean> } show 窗口显示状态，true时显示，否则隐藏
* 返回：
*    @returns { Promise<Number> }
*    错误码:
*      0 = 无错误
*      1 = 平台不支持
*      2 = 参数类型错误
* 例子：
*    NA
* 备注：
*    NA
* 修改:
*   1. 类型 : 创建
*      作者 : 张启丰
*      时间 : 2019.05.06
*      内容 : 所有代码
************************************************************************************************/
function mc_nwjs_win_set_show(show) {
    try {
        var gui = require("nw.gui");

        if (!gui) {
            return 1;
        }

        var win = gui.Window.get();

        if (!win) {
            return 1;
        }

        if ("boolean" !== typeof show) {
            return 2;
        }

        win.show(show);
        return 0;
    } catch (err) {
        return 1;
    }
}

/************************************************************************************************
* 类型:
*    函数
* 功能:
*    设置窗口显示最顶层
* 参数:
*    @param { Promise<Boolean> } enable 是否最顶层
* 返回：
*    @returns { Promise<Number> }
*    错误码:
*      0 = 无错误
*      1 = 平台不支持
*      2 = 参数类型错误
* 例子：
*    NA
* 备注：
*    NA
* 修改:
*   1. 类型 : 创建
*      作者 : 张启丰
*      时间 : 2019.05.06
*      内容 : 所有代码
************************************************************************************************/
function mc_nwjs_win_set_top_most(enable) {
    try {
        var gui = require("nw.gui");

        if (!gui) {
            return 1;
        }

        var win = gui.Window.get();

        if (!win) {
            return 1;
        }

        if ("boolean" !== typeof enable) {
            return 2;
        }

        win.setAlwaysOnTop(enable);
        return 0;
    } catch (err) {
        return 1;
    }
}

/************************************************************************************************
* 类型:
*    函数
* 功能:
*    关闭窗口
* 参数:
*    NA
* 返回：
*    @returns { Promise<Number> }
*    错误码:
*      0 = 无错误
*      1 = 平台不支持
* 例子：
*    NA
* 备注：
*    NA
* 修改:
*   1. 类型 : 创建
*      作者 : 张启丰
*      时间 : 2019.05.06
*      内容 : 所有代码
************************************************************************************************/
function mc_nwjs_win_close() {
    try {
        var gui = require("nw.gui");

        if (!gui) {
            return 1;
        }

        var win = gui.Window.get();

        if (!win) {
            return 1;
        }

        win.close();
        return 0;
    } catch (err) {
        return 1;
    }
}

/************************************************************************************************
* 类型:
*    函数
* 功能:
*    注册/更新最大化回调函数
* 参数:
*    @param {Promise<Function>} func 回调函数
* 返回：
*    @returns { Promise<Number> }
*    错误码:
*      0 = 无错误
*      1 = 平台不支持
* 例子：
*    NA
* 备注：
*    NA
* 修改:
*   1. 类型 : 创建
*      作者 : 张启丰
*      时间 : 2019.05.06
*      内容 : 所有代码
************************************************************************************************/
function mc_nwjs_win_maximize_callback(func) {
    try {
        var gui = require("nw.gui");

        if (!gui) {
            return 1;
        }

        var win = gui.Window.get();

        if (!win) {
            return 1;
        }

        win.on("maximize", func);
        return 0;
    } catch (err) {
        return 1;
    }
}

/************************************************************************************************
* 类型:
*    函数
* 功能:
*    注册/更新窗口尺寸恢复回调函数
* 参数:
*    @param {Promise<Function>} func 回调函数
* 返回：
*    @returns { Promise<Number> }
*    错误码:
*      0 = 无错误
*      1 = 平台不支持
* 例子：
*    NA
* 备注：
*    NA
* 修改:
*   1. 类型 : 创建
*      作者 : 张启丰
*      时间 : 2019.05.06
*      内容 : 所有代码
************************************************************************************************/
function mc_nwjs_win_restore_callback(func) {
    try {
        var gui = require("nw.gui");

        if (!gui) {
            return 1;
        }

        var win = gui.Window.get();

        if (!win) {
            return 1;
        }

        win.on("restore", func);
        return 0;
    } catch (err) {
        return 1;
    }
}

/************************************************************************************************
* 类型:
*    函数
* 功能:
*    创建进程
* 参数:
*    @param { Promise<String> } cmd 要运行的命令，并带上以空格分隔的参数，若是相对地址，必需是基于 ./frame
*                                    命令行中文件，请使用引号约束，例如 '"../addon/abc.exe" arg1 arg2'
* 返回：
*    @returns { Promise<Number> }
*    错误码:
*      0 = 无错误
*      1 = 平台不支持
*      2 = 输入参数错误
* 例子：
*    NA
* 备注：
*    请慎用此接口，在无网卡时（IP.DNS）会造成进程崩溃，替代方案是调用底层SDK接口
* 修改:
*   1. 类型 : 创建
*      作者 : 张启丰
*      时间 : 2019.05.06
*      内容 : 所有代码
************************************************************************************************/
function mc_nwjs_create_process(cmd) {
    try {
        var child_process = require("child_process");

        if (!child_process) {
            return 1;
        }

        if ("string" !== typeof cmd) {
            return 2;
        }

        //var str_base_path = process.cwd() + '/../addon/';
        //var options = {
        //    cwd: str_base_path + wd
        //};
        //child_process.exec(str_base_path + cmd, options);

        child_process.exec(cmd);
    } catch (err) {
        return 1;
    }
    return 0;
}

/************************************************************************************************
* 类型:
*    函数
* 功能:
*    保存文件
* 参数:
*    @param { Promise<String> } str_file_name 默认文件名，函数会启动一个对话框进行文件选择
*    @param { Promise<String> } str_file_data 文件内容
*    @param {Promise<Function>} fn_callback 执行回调函数,函数原型 functiton(err_code)
* 返回：
*    NA
*    fn_callback err_code：
*       0 = 成功
*       1 = 用户选择取消
*       2 = 没有文件内容
*       3 = 文件写失败
*       4 = 未选取文件
*       5 = 未知错误
* 例子：
*    NA
* 备注：
*    NA
* 修改:
*   1. 类型 : 创建
*      作者 : 张启丰
*      时间 : 2020.06.10
*      内容 : 所有代码
************************************************************************************************/
function mc_nwjs_save_file(str_file_name, str_file_data, fn_callback) {
    try {
        var fs = require("fs");
        var str_file_exten = "txt";

        if ("string" === typeof str_file_name && 0 < str_file_name.length) {
            var i_pos = str_file_name.lastIndexOf(".");

            if (0 <= i_pos) {
                str_file_exten = str_file_name.substr(i_pos);
            }
        }

        if ("string" !== typeof str_file_name || 0 === str_file_name.length) {
            str_file_name = "output";
        }

        var str_file_sel_elem_id = "mc_nwjs_save_file_id";
        var elem_file_select = document.getElementById(str_file_sel_elem_id);

        if (!elem_file_select) {
            elem_file_select = document.createElement("input");

            elem_file_select.type = "file";
            elem_file_select.id = str_file_sel_elem_id;
            elem_file_select.style.display = "none";
            document.body.appendChild(elem_file_select);
        }

        elem_file_select.setAttribute("nwsaveas", str_file_name);
        elem_file_select.setAttribute("accept", str_file_exten);
        elem_file_select.value = "";

        elem_file_select.oncancel = function () {
            if (fn_callback) {
                fn_callback(1);
            }
        };

        elem_file_select.onchange = function () {
            var str_file_path_name = this.value.toString();

            if ("string" !== typeof str_file_data || 0 === str_file_data.length) {
                if (fn_callback) {
                    fn_callback(2);
                }
            }

            if ("string" === typeof str_file_path_name && 0 < str_file_path_name.length) {
                fs.writeFile(str_file_path_name, str_file_data, function (err) {
                    var ui_err_code = 0;

                    if (err && 0 < err.toString()) {
                        ui_err_code = 3;
                    }
                    if (fn_callback) {
                        fn_callback(ui_err_code);
                    }
                });
            } else {
                if (fn_callback) {
                    fn_callback(4);
                }
            }
        };

        elem_file_select.click();
    } catch (ex) {
        if (fn_callback) {
            fn_callback(5);
        }
    }
}
